; ***********************************************
; xy_4.ncl
; ***********************************************
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_code.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_csm.ncl"
;************************************************
begin
;************************************************
; read in data
;************************************************
;f     = addfile ("data.81.nc","r")
 f     = addfile ("data.933.nc","r")
 x     = f->SITE_ID                               ; get t data
;y     = f->PREC_ANN                              ; get t data
 y     = f->TNPP_C                                ; get t data
 
 x@long_name = "SITE_ID"
;y@long_name = "PREC_ANN"
 y@long_name = "TNPP_C"
 
;************************************************
; plotting parameters
;************************************************
 wks   = gsn_open_wks ("png","xy")                 ; open workstation

 res                   = True                     ; plot mods desired
;res@tiMainString      = "Observed 81 sites"            ; add title
 res@tiMainString      = "Observed 933 sites"           ; add title
 res@xyMarkLineModes   = "Markers"                ; choose which have markers
 res@xyMarkers         =  16                      ; choose type of marker  
 res@xyMarkerColor     = "red"                    ; Marker color
 res@xyMarkerSizeF     = 0.01                     ; Marker size (default 0.01)

 res@tmLabelAutoStride = True                     ; nice tick mark labels

;plot  = gsn_csm_xy (wks,t&nvalues,t(:),res) ; create plot
 plot  = gsn_csm_xy (wks,x,y,res) ; create plot

;************************************************
; now create our own markers using NhlNewMarker 
; available since ncl version 4.2.0.a030
;************************************************
; this example will create filled squares. You will have to play with
; the numbers a but to get the size and shape you desire. On the
; documentation page for NhlNewMarker, there is a table of values for
; the current marker set, to give you an idea of where to start.

; res@xyMarkerColor = "blue"
; res@tiMainString  = "Make your own marker"
; res@xyMarkers     = NhlNewMarker(wks, "^", 19, 0.0, 0.0, 1.3125, 1.5, 0.0)
; plot              = gsn_csm_xy (wks,x,y,res) 

end
