/* purpose: conversion of binary data with little-endian to ASCII
   Sep. 8, 2006 by Maosheng Zhao */

/* I also accounts for the possible different CPU on different platforms,
   and therefore, it should work on different machines without problem */

#include<stdio.h>
#define COLS 7200
#define ROWS 3600
#define DATA_TYPE unsigned short

/*$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$*/
#define IN_FILE_NAME  "Npp_0.05deg_mean.int16"
#define OUT_FILE_NAME "Npp_0.05deg_mean.ASCII2"
/*$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$*/
int main()
{
    /* definiation of variables will be used */
    FILE *in_f, *out_f;
    static DATA_TYPE data_in[ROWS][COLS];
    int i,j;

    /* the follow definition is for determination the type of CPU */
    int  is_big_endian=0;
    short one=1;
    char *cp;

    /* define a buffer pointer to swap bytes if it is big-endian CPU */
    char temp_char[sizeof(DATA_TYPE)];
    DATA_TYPE *buffer_data; 
    int m;

    /*################################################################*/
    /* main program starts */
    /* open the data file and read all the data */
    in_f = fopen(IN_FILE_NAME,"rb");
    if(in_f == NULL)
    {
	printf("cannot open %s, exit...\n",IN_FILE_NAME);
	exit(0);
    }
    else  /* reading the data */
    {
	/* tell the type of CPU */
	cp = (char*)&one;
	if(*cp == 0)
	   is_big_endian = 1;  /* yes, this is a big-endian CPU */
	else
	   is_big_endian = 0;  /* this is a little-endian CPU */

	if(is_big_endian == 0)
	{
	   printf("This is a little-endian CPU, no need to swap bytes\n");
	   printf("reading data now, please waiting for...\n");
	   fread(data_in,sizeof(DATA_TYPE),COLS*ROWS,in_f);
	}
	else
	{
	   printf("This is a big-endian CPU, which needs to swap bytes\n");
	   printf("reading data now, please waiting for...\n");
	   for(i=0;i<ROWS;i++)
		for(j=0;j<COLS;j++)
		{
	   	   for(m=0;m<sizeof(DATA_TYPE);m++)
			fread(&temp_char[sizeof(DATA_TYPE)-1-m],1,1,in_f);

		   /* swap the byte order */
		   buffer_data = (DATA_TYPE*)temp_char;
		   data_in[i][j] = *buffer_data;
		} /* end of nested loops for i and j */
	}
    }

    /* close the input file */
    fclose(in_f);


    /* write the ASCII to a new file */
    out_f = fopen(OUT_FILE_NAME,"w");
    printf("Please waiting for writing data to %s\n",OUT_FILE_NAME);
    for(i=0;i<ROWS;i++)
	for(j=0;j<COLS;j++)
	    fprintf(out_f,"%6d\n",data_in[i][j]);

    fclose(out_f);

    printf("Finished conversion of binary to ASCII\n");

    return(0);
}
