;*************************************************
; ce_1.ncl
;************************************************
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_code.ncl"  
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_csm.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/contributed.ncl"   
;************************************************
begin
;************************************************
; read in observed data
;************************************************
  diri  = "/fis/cgd/cseg/people/jeff/clamp_data/lai/"
; fili  = "land_class_0.25deg.nc"
  fili  = "land_class_T42_new.nc" 
  f     = addfile(diri+fili,"r")
  print (f)

; y     = f->LAND_CLASS(::10,::10)   ; for 0.25deg
; y    =  (/ y(::-1,:) /)            ; for 0.25deg

  y     = f->LAND_CLASS
  printVarSummary(y)

  y = where(y.eq.0,y@_FillValue,y)

  printVarSummary(y)
  print (min(y)+"/"+max(y))
;************************************************
; create default plot
;************************************************
  wks = gsn_open_wks("ps","xy")              ; open a ps file
  gsn_define_colormap(wks,"gui_default")     ; choose colormap

  res                     = True             ; Use plot options
  res@cnFillOn            = True             ; Turn on color fill
  res@gsnSpreadColors     = True             ; use full colormap
; res@cnFillMode          = "RasterFill"     ; Turn on raster color
; res@lbLabelAutoStride   = True
  res@cnLinesOn           = False            ; Turn off contourn lines
  res@mpFillOn            = False            ; Turn off map fill
  res@tiMainString        = "MODIS LAND CLASS T42"

  res@gsnSpreadColors      = True            ; use full colormap
  res@cnLevelSelectionMode = "ManualLevels"  ; Manual contour invtervals
  res@cnMinLevelValF       = 1.              ; Min level
  res@cnMaxLevelValF       = 19.             ; Max level
  res@cnLevelSpacingF      = 1.              ; interval
  pres                     = True            ; panel plot mods desired
  pres@gsnMaximize         = True            ; fill the page

  plot = gsn_csm_contour_map_ce(wks,y,res)   ; for observed
  gsn_panel(wks,plot,(/1,1/),pres)           ; create panel plot
  system("convert xy.ps xy.png")
end