load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_code.ncl"  
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_csm.ncl"  
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/contributed.ncl"  

begin 
;----------------------------------------------------------
  year_start = 2000
  year_end   = 2005
;----------------------------------------------------------
  diri  = "/fis/cgd/cseg/people/jeff/clamp_data/"
  diro  = "/fis/cgd/cseg/people/jeff/clamp_data/"
  filo1 = "LAI_"+year_start+"-"+year_end+"_ensemble.nc"
  filo2 = "LAI_"+year_start+"-"+year_end+"_mean.nc"
  c = addfile(diro+filo1,"c")
  d = addfile(diro+filo2,"c")

  nyear = year_end - year_start + 1

  files  = new((/nyear/),"string")

  do n = year_start,year_end
     i = n - year_start
     files(i)= diri + "LAI_" + n + "_monthly.nc"
  end do
; print (files)  

  file_list = addfiles(files,"r")
  ListSetType(file_list,"join")
  x = addfiles_GetVar(file_list, files, "LAI")
  print (files)

  x!0  = "case"
  x!1  = "time"
  x!2  = "lat"
  x!3  = "lon"

  y = dim_avg(x(time|:,lat|:,lon|:,case|:))
  print (files)
  c->LAI  = y
  print (files)

  z = dim_avg(y(lat|:,lon|:,time|:))
  d->LAI  = z     
end

