;*************************************************
; ce_1.ncl
;************************************************
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_code.ncl"  
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_csm.ncl"  
;************************************************
begin
;************************************************
; read in observed data
;************************************************
  diri  = "/fis/cgd/cseg/people/jeff/clamp_data/"
  fili  = "LAI_2000-2005_mean_T42.nc"
  f     = addfile(diri+fili,"r")

  y     = f->LAI
  printVarSummary(y)

  print (min(y)+"/"+max(y))

;************************************************
; read in model data
;************************************************
  fili2 = "i01.03cn_1545-1569_ANN_climo.nc"
  g     = addfile(diri+fili2,"r")
  x     = g->LAISUN

  delta = 0.0000001
  x0    = x(0,:,:)
  y = where(ismissing(y).and.(ismissing(x0).or.(x0.lt.delta)),0.,y)
; y = where((y.gt.1000.),1.e+36,y)
  printVarSummary(y)
  print (min(y)+"/"+max(y))
;************************************************
; create default plot
;************************************************
  
; setvalues NhlGetWorkspaceObjectId()
;   "wsMaximumSize" : 199999999
; end setvalues

  wks = gsn_open_wks("ps","xy")         ; open a ps file
; gsn_define_colormap(wks,"wgne15")          ; choose colormap
  gsn_define_colormap(wks,"gui_default")     ; choose colormap

  res                     = True             ; Use plot options
  res@cnFillOn            = True             ; Turn on color fill
  res@gsnSpreadColors      = True            ; use full colormap
; res@cnFillMode          = "RasterFill"     ; Turn on raster color
; res@lbLabelAutoStride   = True
  res@cnLinesOn           = False            ; Turn off contourn lines
  res@mpFillOn            = False            ; Turn off map fill
  res@tiMainString        = "MODIS MOD 15A2 2000-2005"

  res@gsnSpreadColors     = True             ; use full colormap
  res@cnLevelSelectionMode = "ManualLevels"  ; Manual contour invtervals
  res@cnMinLevelValF       = 0.              ; Min level
  res@cnMaxLevelValF       = 10.             ; Max level
  res@cnLevelSpacingF      = 1.              ; interval
  pres                            = True     ; panel plot mods desired
  pres@gsnMaximize                = True     ; fill the page

  plot = gsn_csm_contour_map_ce(wks,y,res)   ; for observed
  gsn_panel(wks,plot,(/1,1/),pres)           ; create panel plot
  system("convert xy.ps xy.png")
end