;*************************************************
; ce_1.ncl
;************************************************
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_code.ncl"  
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_csm.ncl"  
;************************************************
begin
;************************************************
; read in model data
;************************************************
  diri  = "/fis/cgd/cseg/people/jeff/clamp_data/"
  fili  = "i01.03cn_1545-1569_ANN_climo.nc"
; fili  = "i01.04casa_1605-1629_ANN_climo.nc"

  g     = addfile(diri+fili,"r")
  x     = g->TLAI
  print (max(x))
  print (min(x))

;************************************************
; create default plot
;************************************************

  wks = gsn_open_wks("ps","xy")         ; open a ps file
; gsn_define_colormap(wks,"wgne15")          ; choose colormap
  gsn_define_colormap(wks,"gui_default")     ; choose colormap

  res                     = True             ; Use plot options
  res@cnFillOn            = True             ; Turn on color fill
  res@gsnSpreadColors      = True            ; use full colormap
; res@cnFillMode          = "RasterFill"     ; Turn on raster color
; res@lbLabelAutoStride   = True
  res@cnLinesOn           = False            ; Turn off contourn lines
  res@mpFillOn            = False            ; Turn off map fill
; res@tiMainString        = "Observed MODIS MOD 15A2"
  res@tiMainString        = "Model i01.03cn"
; res@tiMainString        = "Model i01.04casa"

  res@gsnSpreadColors     = True             ; use full colormap
  res@cnLevelSelectionMode = "ManualLevels"    ; Manual contour invtervals
  res@cnMinLevelValF       = 0.                ; Min level
  res@cnMaxLevelValF       = 10.             ; Max level
  res@cnLevelSpacingF      = 1.              ; interval

  plot = gsn_csm_contour_map_ce(wks,x(0,:,:),res)         ; for model
  system("convert xy.ps xy.png")
end