;*************************************************
; ce_1.ncl
;************************************************
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_code.ncl"  
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_csm.ncl"  
;************************************************
begin
;************************************************
; read data
;************************************************
  grid = "1x1"
; grid = "T31"
; grid = "T42"
; grid = "1.9"

  diri  = "/fis/cgd/cseg/people/jeff/clamp_data/observed/biomass/"
  fili  = "amazon_mask_"+ grid + ".nc"
  f     = addfile (diri+fili,"r")

  y = f->mask_amazon

  printVarSummary(y)

  wks = gsn_open_wks ("ps","test")   ; open workstation
  gsn_define_colormap(wks,"gui_default")     ; choose colormap

;-----------------------------------------
; plot area sum

  gRes  = True
  gRes@txFontHeightF = 0.02
; gRes@txAngleF = 90

  Sum_area = 7.41

  area_sum_text = "(mask area = "+sprintf("%.2f", Sum_area)+"(x1.e12 m2))"

  gsn_text_ndc(wks,area_sum_text,0.50,0.80,gRes)
;-----------------------------------------

;************************************************
; create default plot
;************************************************

  res                     = True             ; Use plot options
  res@cnFillOn            = True             ; Turn on color fill
  res@gsnSpreadColors      = True            ; use full colormap
; res@cnFillMode          = "RasterFill"     ; Turn on raster color
; res@lbLabelAutoStride   = True
  res@cnLinesOn           = False            ; Turn off contourn lines
  res@mpFillOn            = False            ; Turn off map fill
  res@gsnAddCyclic        = False
  res@tiMainString        = "Amazon Mask: grid = "+ grid

  res@mpMinLatF            = -21.1      ; range to zoom in on
  res@mpMaxLatF            =  13.8
  res@mpMinLonF            =  277.28
  res@mpMaxLonF            =  326.43

  res@gsnSpreadColors     = True             ; use full colormap
  res@cnLevelSelectionMode = "ManualLevels"  ; Manual contour invtervals
; res@cnMinLevelValF       = 1.              ; Min level
; res@cnMaxLevelValF       = 11.             ; Max level
; res@cnLevelSpacingF      = 1.              ; interval
  res@cnMinLevelValF       = 0.              ; Min level
  res@cnMaxLevelValF       = 1.              ; Max level
  res@cnLevelSpacingF      = 0.1             ; interval

; pres                     = True            ; panel plot mods desired
; pres@gsnMaximize         = True            ; fill the page

  plot = gsn_csm_contour_map_ce(wks,y,res)   ; for observed
; gsn_panel(wks,plot,(/1,1/),pres)           ; create panel plot
; system("convert xy.ps xy.png")
end