;*************************************************
; ce_1.ncl
;************************************************
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_code.ncl"  
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_csm.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/contributed.ncl"  
;************************************************
begin

; read data

  diri  = "/fis/cgd/cseg/people/jeff/clamp_data/model/"
  fili =  "class_pft_T42.nc"
  fili =  "class_pft_1.9.nc"
  f = addfile(diri+fili,"r")

  x     = f->CLASS_PFT
  printVarSummary(x)

;************************************************
; create default plot
;************************************************

  wks = gsn_open_wks("ps","class")              ; open a ps file
  gsn_define_colormap(wks,"gui_default")     ; choose colormap

  res                     = True             ; Use plot options
  res@cnFillOn            = True             ; Turn on color fill
  res@gsnSpreadColors     = True             ; use full colormap
  res@cnLinesOn           = False            ; Turn off contourn lines
  res@mpFillOn            = False            ; Turn off map fill
  res@tiMainString        = "Class"

  res@gsnSpreadColors      = True            ; use full colormap
  res@cnLevelSelectionMode = "ManualLevels"  ; Manual contour invtervals
  res@cnMinLevelValF       = 0.              ; Min level
  res@cnMaxLevelValF       = 16.             ; Max level
  res@cnLevelSpacingF      = 1.              ; interval

  plot = gsn_csm_contour_map_ce(wks,x,res)   

end