;************************************************
;    Read ascii, Write nc                         
;************************************************
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_code.ncl"  
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_csm.ncl"  
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/contributed.ncl"   
;************************************************
begin
;---------------------------------------------------
; final data
                                    
  c = addfile("amazon_mask_1x1.nc","c") 
       
  nlat  = 180
  nlon  = 360  

;************************************************
; read 1x1 mask data
;************************************************

  diri  = "/fis/cgd/cseg/people/jeff/clamp_data/observed/biomass/"
  fili  = "mask_1x1.txt"
  t     = asciiread(diri+fili,(/180,360/),"integer")

  printVarSummary(t)

  print (min(t)+"/"+max(t))                      

  lon      = new((/nlon/),float)
  lat      = new((/nlat/),float)

; data is (89.5N->89.5S) (-179.5->179.5)

; sam result
; lon = fspan(-179.5,179.5,nlon)
; lat = fspan( -89.5, 89.5,nlat)
 
  do i = 0,nlon-1
     lon(i) = -179.5 + i*(360./nlon)
  end do
 
  do j = 0,nlat-1
;    lat(j) = -89.5 + j*(180./nlat)
     lat(j) =  89.5 - j*(180./nlat)
  end do

; print (lon)
; print (lat)        
;=============================
    ;  create lat and long coordinate variables
    ;============================                                         
     lon!0          = "lon"
     lon@long_name  = "lon"
     lon@units      = "degrees-east"
     lon&lon        = lon

     lat!0          = "lat"
     lat@long_name  = "lat"
     lat@units      = "degrees_north"
     lat&lat        = lat
    ;=============================
    ;  name dimensions of t and assign coordinate variables
    ;============================  
     t!0    = "lat"
     t!1    = "lon"
     t&lat  = lat
     t&lon  = lon
     t@long_name = "amazon mask"
;    t@units     = ""
     t@_FillValue= -999         
     t@missing_value= -999 
        
  c->mask_amazon  = t
  c->lat  = lat
  c->lon  = lon

;************************************************
; create default plot
;************************************************

  wks = gsn_open_wks("ps","xy")         ; open a ps file
  gsn_define_colormap(wks,"gui_default")     ; choose colormap

  res                     = True             ; Use plot options
  res@cnFillOn            = True             ; Turn on color fill
  res@gsnSpreadColors      = True            ; use full colormap
; res@cnFillMode          = "RasterFill"     ; Turn on raster color
; res@lbLabelAutoStride   = True
  res@cnLinesOn           = False            ; Turn off contourn lines
  res@mpFillOn            = False            ; Turn off map fill
  res@gsnAddCyclic        = False
  res@tiMainString        = "LC15_amazon_biomass"

  res@mpMinLatF            = -21.1      ; range to zoom in on
  res@mpMaxLatF            =  13.8
  res@mpMinLonF            =  277.28
  res@mpMaxLonF            =  326.43

  res@gsnSpreadColors     = True             ; use full colormap
  res@cnLevelSelectionMode = "ManualLevels"  ; Manual contour invtervals
; res@cnMinLevelValF       = 1.              ; Min level
; res@cnMaxLevelValF       = 11.             ; Max level
; res@cnLevelSpacingF      = 1.              ; interval
  res@cnMinLevelValF       = 0.              ; Min level
  res@cnMaxLevelValF       = 1.             ; Max level
  res@cnLevelSpacingF      = 0.1              ; interval
; pres                            = True     ; panel plot mods desired
; pres@gsnMaximize                = True     ; fill the page

  plot = gsn_csm_contour_map_ce(wks,t,res)   ; for observed

end
