;************************************************************
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_code.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_csm.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/contributed.ncl"
;************************************************************

begin

  year_new = 2000
  file_input  = "1999_L4_m.nc"
  file_output = year_new+"_L4_m.nc"
 
  a = addfile(file_input,"r")
  b = addfile(file_output,"c")
;-------------------------------------------------------------------
; Enter predefine phase.

; Write global attributes to file. It's okay to do this before 
; predefining the file's variables. We are still in "define" mode.

  fAtt               = True
  fAtt@description   = "Data read in from " + file_input 
  fAtt@creation_date = systemfunc ("date")        
  fileattdef( b, fAtt )        

  filedimdef( b,"year",-1,True)
;-------------------------------------------------------------------
  month_of_year = (/1,2,3,4,5,6,7,8,9,10,11,12/)
 
  Var = getfilevarnames(a)
  nVar= dimsizes(Var)

; do n = 0,nVar-1
;    print( (/Var(n)/))
; end do
 
  do n = 0,nVar-1

     if (Var(n).ne."year" .and. Var(n).ne."Month" .and. Var(n).ne."n_days" .and. Var(n).ne."lat" .and. Var(n).ne."lon" ) then

        temp = a->$Var(n)$
        temp(0,:) = -999.
        b->$Var(n)$ = temp
     else

     if (Var(n).eq."year") then
        b->$Var(n)$ = year_new
     end if

     if (Var(n).eq."Month") then
        Month = a->$Var(n)$
        Month(0,:)= month_of_year + year_new * 100   
        b->$Var(n)$ = Month
     end if

     if (Var(n).eq."n_days" .or. Var(n).eq."lat" .or. Var(n).eq."lon") then
        b->$Var(n)$ = a->$Var(n)$
     end if

     end if
  end do
 
end
