; ***********************************************
; xy_4.ncl
; ***********************************************
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_code.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_csm.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/contributed.ncl"
;************************************************
begin
;************************************************
; read in data
;************************************************
 g     = addfile ("Npp_T31_mean.nc","r")
 c     = g->NPP
 u     = zonalAve(c)  
 
;f     = addfile ("i01.03cn_1545-1569_ANN_climo.nc","r")
 f     = addfile ("i01.04casa_1605-1629_ANN_climo.nc","r")
 b     = f->NPP      

 sec_to_year = 86400.*365.

 b = b * sec_to_year
 v = zonalAve(b)

 b@long_name = "NPP (gC/m2/year)"
 
 ccr = esccr(u,v(0,:),0)

 print (ccr)

end
