;*************************************************
; ce_1.ncl
;************************************************
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_code.ncl"  
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_csm.ncl"  
;************************************************
begin
;************************************************
; read in observed data
;************************************************
;f     = addfile ("Npp_0.05deg_mean.nc","r")
;y     = f->NPP(::10,::10)                 ; for observed 0.05deg
 f     = addfile ("Npp_T42_mean.nc","r")
 y     = f->NPP
;************************************************
; read in model data
;************************************************
 g     = addfile ("i01.03cn_1545-1569_ANN_climo.nc","r")
;g     = addfile ("i01.04casa_1605-1629_ANN_climo.nc","r")
 x     = g->NPP

 delta = 0.00000000001
 x0    = x(0,:,:)
 y = where(ismissing(y).and.(ismissing(x0).or.(x0.lt.delta)),0.,y)

 y@units = "gC/m^2/year" 
;************************************************
; create default plot
;************************************************
  
; setvalues NhlGetWorkspaceObjectId()
;   "wsMaximumSize" : 199999999
; end setvalues

  wks = gsn_open_wks("png","xy")         ; open a ps file
; gsn_define_colormap(wks,"wgne15")          ; choose colormap
  gsn_define_colormap(wks,"gui_default")     ; choose colormap

  res                     = True             ; Use plot options
  res@cnFillOn            = True             ; Turn on color fill
  res@gsnSpreadColors      = True            ; use full colormap
; res@cnFillMode          = "RasterFill"     ; Turn on raster color
; res@lbLabelAutoStride   = True
  res@cnLinesOn           = False            ; Turn off contourn lines
  res@mpFillOn            = False            ; Turn off map fill
  res@tiMainString        = "Observed MODIS MOD 17"
; res@tiMainString        = "Model i01.03cn"
; res@tiMainString        = "Model i01.04casa"

  res@gsnSpreadColors     = True             ; use full colormap
  res@cnLevelSelectionMode = "ManualLevels"    ; Manual contour invtervals
  res@cnMinLevelValF       = 0.                ; Min level
  res@cnMaxLevelValF       = 2200.             ; Max level
  res@cnLevelSpacingF      = 200.              ; interval

  plot = gsn_csm_contour_map_ce(wks,y,res)         ; for observed

end