load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_code.ncl"  
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_csm.ncl"  
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/contributed.ncl"  

begin
  nlat  = 3600
  mlon  = 7200

  diri  = "/fis/cgd/cseg/people/jeff/clamp/"
  fili  = "Npp_0.05deg_mean.int16"

  diro  = "/fis/cgd/cseg/people/jeff/clamp/"
  filo  = "Npp_0.05deg_mean_3.nc"
  c = addfile(diro+filo,"c")

; I think  (a) the file is "little endian"; read into short
;          (b) the _FillValue is 32700

  setfileoption("bin","ReadByteOrder","LittleEndian")
  xShort= fbindirread(diri+fili,0, (/nlat,mlon/), "short")
  xShort@_FillValue= inttoshort(32700)

;;xShort@scale_factor = ?????
;;xShort@add_offset   = ?????

  x     = short2flt( xShort )

;;print(xShort(:,1800)+"   "+x(:,1800))      ; look at the values
  delete(xShort)

  x@long_name  = "net primary production"
  x@units      = "gC/m^2/year"
; x@_FillValue = -17281                      ; orig fill    
  x@_FillValue =  1e20                       ; new fill

  lat  = latGlobeFo(nlat, "lat", "latitude", "degrees_north")
  lat  = (/ lat(::-1) /)                     ; make N->S
  lon  = lonGlobeFo(mlon, "lon", "longitude", "degrees_east")
  lon  = (/ lon - 180. /) ; subtract 180 from all values 
  lon&lon = lon           ; update coordinates

  x!0  = "lat"
  x!1  = "lon"
  x&lat=  lat
  x&lon=  lon

  c->NPP  = x

  exit
  
;************************************************
; create default plot
;************************************************
  
  setvalues NhlGetWorkspaceObjectId()
    "wsMaximumSize" : 199999999
  end setvalues

  wks = gsn_open_wks("ps","Npp_rdBinPlt")                  ; open a ps file
 ;gsn_define_colormap(wks,"wgne15")          ; choose colormap

  res                     = True             ; Use plot options
  res@cnFillOn            = True             ; Turn on color fill
  res@cnFillMode          = "RasterFill"     ; Turn on raster color
  res@lbLabelAutoStride   = True
  res@cnLinesOn           = False            ; Turn off contourn lines
 ;res@gsnSpreadColors     = True             ; use full colormap
  res@mpFillOn            = False            ; Turn off map fill

 ;res@cnLevelSelectionMode = "ManualLevels"    ; Manual contour invtervals
 ;res@cnMinLevelValF       =                   ; Min level
 ;res@cnMaxLevelValF       =                   ; Max level
 ;res@cnLevelSpacingF      =                   ; interval
  res@tiMainString         = fili

  plot = gsn_csm_contour_map_ce(wks,x,res)    

end

