;************************************************
;    Read ascii, Write nc                         
;************************************************
;load "/fs/cgd/data0/shea/nclGSUN/gsn_code.ncl"   
;load "/fs/cgd/data0/shea/nclGSUN/gsn_csm.ncl"    
;load "/fs/cgd/data0/shea/nclGSUN/shea_util.ncl"  
;************************************************
begin
;---------------------------------------------------
; final data                                    
  c = addfile("Npp_0.05deg_mean4.nc","c")
  filedimdef(c,"time",-1,True) 
       
  nlat  = 180*20 
  nlon  = 360*20  
 
;---------------------------------------------------
; input data
  b = "Npp_0.05deg_mean.ASCII2"                    
 
  t        = new((/1,nlat,nlon/),float)
  lon      = new((/nlon/),float)
  lat      = new((/nlat/),float)
  time     = new((/1/),integer)

; sam result
; lon = fspan(-180.,179.95,nlon)
; lat = fspan(-90. , 89.95,nlat)
 
  do i = 0,nlon-1
     lon(i) = -180. + i*(360./nlon)
  end do
 
  do j = 0,nlat-1
     lat(j) =  -90. + j*(180./nlat)
  end do
 
  time = 1

; print (lon)
; print (lat)       
; print (time) 
;=============================
    ;  create lat and long coordinate variables
    ;============================                                         
     lon!0          = "lon"
     lon@long_name  = "lon"
     lon@units      = "degrees-east"
     lon&lon        = lon

     lat!0          = "lat"
     lat@long_name  = "lat"
     lat@units      = "degrees_north"
     lat&lat        = lat
    ;=============================
    ;  name dimensions of t and assign coordinate variables
    ;============================
     t!0    = "time"  
     t!1    = "lat"
     t!2    = "lon"
     t&time = time
     t&lat  = lat
     t&lon  = lon
     t@long_name = "net primary production"
     t@units     = "gC/m^2/year"
     t@_FillValue= 1.e+36         
     t@missing_value= 1.e+36         

  t(0,:,:) = asciiread(b,(/nlat,nlon/),"float")

  c->NPP  = t
  c->lat  = lat
  c->lon  = lon
  c->time = time

  do i = 0,nlon-1           
  do j = 0,nlat-1                                                       
  if (t(0,j,i) .gt. 0.) then
     print (t(0,j,i))
  end if
  end do
  end do
end
