;*************************************************
; ce_1.ncl
;************************************************
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_code.ncl"  
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_csm.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/contributed.ncl"  
;************************************************
begin
;************************************************
; read in observed data
;************************************************
  diri  = "/fis/cgd/cseg/people/jeff/clamp_data/lai/"
  fili  = "LAI_2000-2005_ensemble_T42.nc"
  f     = addfile(diri+fili,"r")

  z     = f->LAI
  y     = z(0,:,:)
  y@long_name = "Days of Growing Season"
 
  dsizes_z = dimsizes(z)
  ntime    = dsizes_z(0)
  nlat     = dsizes_z(1)
  nlon     = dsizes_z(2)

 day_of_data = (/31,28,31,30,31,30,31,31,30,31,30,31/)

  do j = 0,nlat-1
  do i = 0,nlon-1
     nday = 0.
     do k = 0,ntime-1
        if (.not. ismissing(z(k,j,i)) .and. z(k,j,i) .gt. 1.0) then
           nday = nday + day_of_data(k)
        end if
     end do
     y(j,i) = nday
  end do
  end do

  print (min(y)+"/"+max(y))

;************************************************
; read in model data
;************************************************
  diri2  = "/fis/cgd/cseg/people/jeff/clamp_data/model/"
  fili2 = "i01.03cn_1545-1569_ANN_climo.nc"
  g     = addfile(diri2+fili2,"r")
  x     = g->TLAI

  delta = 0.000001
  x0    = x(0,:,:)
  y = where(ismissing(y).and.(ismissing(x0).or.(x0.lt.delta)),y@_FillValue,y)
;************************************************
; create default plot
;************************************************

  wks = gsn_open_wks("ps","xy")         ; open a ps file
  gsn_define_colormap(wks,"gui_default")     ; choose colormap

  res                     = True             ; Use plot options
  res@cnFillOn            = True             ; Turn on color fill
  res@gsnSpreadColors      = True            ; use full colormap
; res@cnFillMode          = "RasterFill"     ; Turn on raster color
; res@lbLabelAutoStride   = True
  res@cnLinesOn           = False            ; Turn off contourn lines
  res@mpFillOn            = False            ; Turn off map fill
  res@tiMainString        = "MODIS MOD 15A2 2000-2005"

  res@gsnSpreadColors     = True             ; use full colormap
  res@cnLevelSelectionMode = "ManualLevels"  ; Manual contour invtervals
  res@cnMinLevelValF       = 0.              ; Min level
  res@cnMaxLevelValF       = 390.            ; Max level
  res@cnLevelSpacingF      = 30.             ; interval

; pres                            = True     ; panel plot mods desired
; pres@gsnMaximize                = True     ; fill the page

  plot = gsn_csm_contour_map_ce(wks,y,res)   ; for observed

; gsn_panel(wks,plot,(/1,1/),pres)           ; create panel plot
  system("convert xy.ps xy.png")
end