; ***********************************************
; interpolate into model grids (T31)
; ***********************************************
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_code.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_csm.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/contributed.ncl"
;************************************************
begin

  year = 2000

;************************************************
; output data
;************************************************
  diro  = "/fis/cgd/cseg/people/jeff/clamp_data/lai/ob/"
  filo  = "LAI_" + year + "_monthly_1.9.nc"

  c = addfile(diro+filo,"c")
  filedimdef(c,"time",-1,True)

;************************************************
; read in observed data
;************************************************
  diri  = "/fis/cgd/cseg/people/jeff/clamp_data/lai/ob/"
  fili  = "LAI_" + year + "_monthly.nc"

  g     = addfile (diri+fili,"r")
  bi    = g->LAI   
  xi    = g->lon 
  yi    = g->lat

;************************************************
; change into 0-360E, 90S-90N
;************************************************
 
 yi    = (/ yi(::-1) /)
 bi    = (/ bi(:,::-1,:) /)
 printVarSummary(bi)

 b2    = bi
 x2    = xi   
 
 nx = dimsizes(xi)
 do i= 0,nx-1
    if (i .lt. 3600) then
       p = i + 3600
       xi(p) = x2(i) + 360.      
    else
       p = i - 3600
       xi(p) = x2(i)
    end if
    bi(:,:,p)= b2(:,:,i) 
 end do

 bi&lat =  yi
 bi&lon =  xi

;print (xi)
;print (yi)

;************************************************
; read in model data
;************************************************
 diri2  = "/fis/cgd/cseg/people/jeff/clamp_data/model/"
 fili2  = "newcn05_ncep_1i_MONS_climo_lnd.nc"
 f      = addfile (diri2+fili2,"r")

 lon    = f->lon     
 lat    = f->lat
 nlon   = dimsizes(lon)
 nlat   = dimsizes(lat)      

; print (xi)
; print (yi)
; print (xo)
; print (yo)

 bo = new((/12,nlat,nlon/),float)

 do m = 0,11
    do j=0,nlat-1
       if (j.eq.0 .or. j.eq.nlat-1) then
          if (j.eq.0) then
             LATS = -90.          
             LATN = lat(j)+0.5*(lat(j+1)-lat(j))
          end if
          if (j.eq.nlat-1) then
             LATS = lat(j)-0.5*(lat(j)-lat(j-1))
             LATN = 90.                  
          end if
       else
          LATS = lat(j)-0.5*(lat(j)-lat(j-1))
          LATN = lat(j)+0.5*(lat(j+1)-lat(j))
       end if
 
      do i=0,nlon-1
       if (i.eq.0 .or. i.eq.nlon-1) then
          if (i.eq.0) then
             LONL = 0.          
             LONR = lon(i)+0.5*(lon(i+1)-lon(i))
          end if
          if (i.eq.nlon-1) then
             LONL = lon(i)-0.5*(lon(i)-lon(i-1))
             LONR = 360.                 
          end if
       else
          LONL = lon(i)-0.5*(lon(i)-lon(i-1))
          LONR = lon(i)+0.5*(lon(i+1)-lon(i))
       end if

;print (LATS)
;print (LATN)
;print (LONL)
;print (LONR)

         bo(m,j,i) = avg(bi(m,{LATS:LATN},{LONL:LONR}))  
      end do 
    end do
  end do

  bo!0   = "time"
  bo!1   = "lat"
  bo!2   = "lon"
  bo&time= bi&time
  bo&lat = lat
  bo&lon = lon
  bo@units      = bi@units
  bo@long_name  = bi@long_name
  bo@_FillValue = bi@_FillValue

  c->LAI  = bo
end