load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_code.ncl"  
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_csm.ncl"  
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/contributed.ncl"  

begin
  nlat  = 3600
  mlon  = 7200

  diri  = "/fis/cgd/cseg/people/jeff/clamp_data/"
  fili  = "MOD15A2_GEO_2000001.nc"
  a  = addfile(diri+fili,"r")

  y = a->Lai_0_05deg    ; byte
  y@_FillValue = inttobyte(253)
  y@_FillValue = inttobyte(255)

  x = byte2flt(y)
  
  x@_FillValue =  1.e+36                     ; new fill

  lat  = latGlobeFo(nlat, "lat", "latitude", "degrees_north")
  lat  = (/ lat(::-1) /)                     ; make N->S
  lon  = lonGlobeFo(mlon, "lon", "longitude", "degrees_east")
  lon  = (/ lon - 180. /) ; subtract 180 from all values 
  lon&lon = lon           ; update coordinates

  x!0  = "lat"
  x!1  = "lon"
  x&lat=  lat
  x&lon=  lon

  y!0  = "lat"
  y!1  = "lon"
  y&lat=  lat
  y&lon=  lon

  iy   = new (dimsizes(y), "integer", -999)
  iy   = y

  iy!0  = "lat"
  iy!1  = "lon"
  iy&lat=  lat
  iy&lon=  lon

  print(y(:,{130})+"   "+ iy(:,{130})+"   "+x(:,{130}))



; diro  = "/fis/cgd/cseg/people/jeff/clamp_data/"
; filo  = "LAI_2000001_2.nc"
; c = addfile(diro+filo,"c")
; c->LAI  = x 
end

