; ***********************************************
; using gsn_table for all
; output: line plot for each site (4 fields)
;         table for M_score
; ***********************************************
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_code.ncl.test"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_csm.ncl.test"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/contributed.ncl"
;load "/fis/cgd/cseg/people/jeff/clamp/co2/metrics_table.ncl"
;************************************************
begin

  plot_type     = "ps"
  plot_type_new = "png"

;************************************************
; read model data
;************************************************
  model_name = "newcn"
  film = "newcn05_ncep_1i_MONS_climo_lnd.nc"

; model_name = "b30.061n"
; film = "b30.061n_1995-2004_MONS_climo_lnd.nc"
;--------------------------------------------
  dirm = "/fis/cgd/cseg/people/jeff/clamp_data/model/"
  fm    = addfile(dirm+film,"r")

  xm    = fm->lon
  ym    = fm->lat
  nlat = dimsizes(ym)
  nlon = dimsizes(xm)

  nmon      = 12
  nfield    = 4

  data_mod0 = new ((/nfield,nmon,nlat,nlon/),float)

; change to unit of observed (u mol/m2/s)
; Model_units [=] gC/m2/s
; 12. = molecular weight of C
; u mol = 1e-6 mol 
  data = fm->NEE

  factor = 1e6/12.

  data_mod0(0,:,:,:) = data(:,:,:) * factor
  delete (data)
; data  = fm->LATENT
  data1 = fm->FCEV
  data2 = fm->FCTR
  data3 = fm->FGEV
  data_mod0(2,:,:,:) = data1(:,:,:)+data2(:,:,:)+data3(:,:,:) 
  delete (data1)
  delete (data2)
  delete (data3)

  data  = fm->FSH
  data_mod0(3,:,:,:) = data(:,:,:) 
  delete (data)

; data  = fm->NETRAD
  data1 = fm->FSA
  data2 = fm->FIRA
  data_mod0(1,:,:,:) = data1(:,:,:)-data2(:,:,:)-data_mod0(2,:,:,:)-data_mod0(3,:,:,:) 
  delete (data1)
  delete (data2)

; printVarSummary (data_mod0)
;************************************************
; read in data: observed
;************************************************
 station = (/"BOREAS_NSA_OBS" \
            ,"CastelPorziano" \
            ,"Hyytiala" \
            ,"Kaamanen" \
            ,"LBA_Tapajos_KM67" \
            ,"Lethbridge" \
            ,"Tharandt" \
            ,"Vielsalm" \
            /)

 year_ob = (/"1994-2004" \
            ,"1997-2003" \
            ,"1996-2003" \
            ,"2000-2003" \
            ,"2002-2005" \
            ,"1999-2004" \
            ,"1996-2003" \
            ,"1998-2003" \
            /)

 field   = (/"CO2 Flux" \
            ,"Net Radiation" \
            ,"Latent Heat" \
            ,"Sensible Heat" \
            /)

 nstation  = dimsizes(station)
 nmon      = 12
 nfield    = dimsizes(field)

 data_ob   = new ((/nstation, nfield, nmon/),float)
 lat_ob    = new ((/nstation/),float)
 lon_ob    = new ((/nstation/),float)

 diri_root  = "/fis/cgd/cseg/people/jeff/clamp_data/fluxnet/"

 do n = 0,nstation-1
    diri = diri_root + station(n)+"/"
    fili = station(n)+"_"+year_ob(n)+"_monthly.nc"
    g     = addfile (diri+fili,"r")
 
    lon_ob(n) = g->lon 
    lat_ob(n) = g->lat

    data      = g->CO2_FLUX
    data_ob(n,0,:) = dim_avg(data(month|:,year|:))
    delete (data)

    data      = g->RAD_FLUX
    data_ob(n,1,:) = dim_avg(data(month|:,year|:))
    delete (data)

    data      = g->LH_FLUX
    data_ob(n,2,:) = dim_avg(data(month|:,year|:))
    delete (data)

    data      = g->SH_FLUX
    data_ob(n,3,:) = dim_avg(data(month|:,year|:))
    delete (data)

    delete (g)
 end do
 
;print (lat_ob)
;print (lon_ob)
;printVarSummary (data_ob)

;************************************************************
; interpolate model data into observed station
; note: model is 0-360E, 90S-90N
;************************************************************

; to be able to handle observation at (-89.98,-24.80)
; print (ym(0))
  ym(0) = -90.  

  yy = linint2_points_Wrap(xm,ym,data_mod0,True,lon_ob,lat_ob,0)

  delete (data_mod0)
  yy!0 = "field"
  data_mod = yy(pts|:,field|:,time|:)
; printVarSummary (data_mod)

;************************************************************
; compute correlation coef and M score
;************************************************************

 score_max = 5.

 ccr     = new ((/nstation, nfield/),float)
 M_score = new ((/nstation, nfield/),float) 

 do n=0,nstation-1
 do m=0,nfield-1   
    ccr(n,m) = esccr(data_ob(n,m,:),data_mod(n,m,:),0)
    bias = sum(abs(data_mod(n,m,:)-data_ob(n,m,:))/(abs(data_mod(n,m,:))+abs(data_ob(n,m,:))))
    M_score(n,m) = (1. -(bias/nmon)) * score_max
 end do
 end do

;*******************************************************************
; for station line plot
;*******************************************************************

; for x-axis in xyplot
  mon = ispan(1,12,1)
  mon@long_name = "month"

  res                   = True               ; plot mods desired
  res@xyLineThicknesses = (/2.0,2.0/)        ; make 2nd lines thicker
  res@xyLineColors      = (/"blue","red"/)   ; line color (ob,model)
;-------------------------------------------------------------------------
; Add a boxed legend using the more simple method

  res@pmLegendDisplayMode    = "Always"
; res@pmLegendWidthF         = 0.1
  res@pmLegendWidthF         = 0.08
  res@pmLegendHeightF        = 0.06
; res@pmLegendOrthogonalPosF = -1.17
; res@pmLegendOrthogonalPosF = -1.00  ;(downward)
  res@pmLegendOrthogonalPosF = -0.30  ;(downward)

; res@pmLegendParallelPosF   =  0.18
  res@pmLegendParallelPosF   =  0.23  ;(rightward)

; res@lgPerimOn             = False
  res@lgLabelFontHeightF     = 0.015
  res@xyExplicitLegendLabels = (/"observed",model_name/)
;-------------------------------------------------------------------
; for panel plot
  res@gsnFrame     = False                   ; Do not draw plot 
  res@gsnDraw      = False                   ; Do not advance frame

  pres                            = True     ; panel plot mods desired
  pres@gsnPanelYWhiteSpacePercent = 5        ; increase white space around
                                             ; indiv. plots in panel
  pres@gsnMaximize                = True     ; fill the page
;-------------------------------------------------------------------

  plot_data   = new((/2,12/),float)
  plot_data!0 = "case"
  plot_data!1 = "month"

  do n = 0,nstation-1
;----------------------------
; for observed

    plot_name = station(n)+"_ob"    
    title = station(n)+"("+sprintf("%5.2f",lat_ob(n))+","+sprintf("%5.2f",lon_ob(n))+")"
    res@tiMainString = title

    wks = gsn_open_wks (plot_type,plot_name)
    plot=new(4,graphic)                        ; create graphic array   
                           
    plot_data(0,:) = (/data_ob (n,0,:)/)
    plot_data@long_name = field(0)   
    plot(0)=gsn_csm_xy(wks,mon,plot_data(0,:),res)   ; create plot 1

    plot_data(0,:) = (/data_ob (n,1,:)/)
    plot_data@long_name = field(1)
    plot(1)=gsn_csm_xy(wks,mon,plot_data(0,:),res)   ; create plot 2

    plot_data(0,:) = (/data_ob (n,2,:)/)
    plot_data@long_name = field(2)   
    plot(2)=gsn_csm_xy(wks,mon,plot_data(0,:),res)   ; create plot 3

    plot_data(0,:) = (/data_ob (n,3,:)/)
    plot_data@long_name = field(3)
    plot(3)=gsn_csm_xy(wks,mon,plot_data(0,:),res)   ; create plot 4

    gsn_panel(wks,plot,(/2,2/),pres)                 ; create panel plot

    system("convert "+plot_name+"."+plot_type+" "+plot_name+"."+plot_type_new)
    system("rm "+plot_name+"."+plot_type)
    clear (wks)  
    delete (plot)
;----------------------------
; for model_vs_ob

    plot_name = station(n)+"_model_vs_ob"
    title = station(n)+"("+sprintf("%5.2f",lat_ob(n))+","+sprintf("%5.2f",lon_ob(n))+")"    
    res@tiMainString = title

    wks = gsn_open_wks (plot_type,plot_name)
    plot=new(4,graphic)                        ; create graphic array   
                           
    plot_data(0,:) = (/data_ob (n,0,:)/)
    plot_data(1,:) = (/data_mod(n,0,:)/)
    plot_data@long_name = field(0)   
    plot(0)=gsn_csm_xy(wks,mon,plot_data,res)   ; create plot 1

    plot_data(0,:) = (/data_ob (n,1,:)/)
    plot_data(1,:) = (/data_mod(n,1,:)/)
    plot_data@long_name = field(1)
    plot(1)=gsn_csm_xy(wks,mon,plot_data,res)   ; create plot 2

    plot_data(0,:) = (/data_ob (n,2,:)/)
    plot_data(1,:) = (/data_mod(n,2,:)/)
    plot_data@long_name = field(2)   
    plot(2)=gsn_csm_xy(wks,mon,plot_data,res)   ; create plot 3

    plot_data(0,:) = (/data_ob (n,3,:)/)
    plot_data(1,:) = (/data_mod(n,3,:)/)
    plot_data@long_name = field(3)
    plot(3)=gsn_csm_xy(wks,mon,plot_data,res)   ; create plot 4

    gsn_panel(wks,plot,(/2,2/),pres)                 ; create panel plot

    system("convert "+plot_name+"."+plot_type+" "+plot_name+"."+plot_type_new)
    system("rm "+plot_name+"."+plot_type)
    clear (wks)  
    delete (plot)
 end do

;*******************************************************************
; for table of site score
;*******************************************************************

  table_length = 0.8 

; table header name
  table_header_name = "Site" 

; column (not including header column)
  col_header = (/"Latitude","Longitude","observed" \
                ,"CO2 Flux","Net Radiation","Latent Heat" \
                ,"Sensible Heat","Average" \
                /)
  ncol = dimsizes(col_header) 

; row (not including header row) 
  nrow       = nstation + 1
  row_header = new ((/nrow/),string )
  row_header(0:nstation-1) = station(:)
  row_header(nrow-1)       = "All Sites" 

; Table header
  ncr1  = (/1,1/)               ; 1 row, 1 column
  x1    = (/0.005,0.15/)        ; Start and end X
  y1    = (/0.800,0.895/)       ; Start and end Y
  text1 = table_header_name
  res1               = True
  res1@txFontHeightF = 0.03
  res1@gsFillColor   = "CornFlowerBlue"

; Column header (equally space in x2)
  ncr2  = (/1,ncol/)            ; 1 rows, ncol columns
  x2    = (/x1(1),0.995/)       ; start from end of x1
  y2    = y1                    ; same as y1
  text2 = col_header
  res2               = True
  res2@txFontHeightF = 0.010
  res2@gsFillColor   = "Gray"

; Row header (equally space in y2)
  ncr3  = (/nrow,1/)                 ; nrow rows, 1 columns
  x3    = x1                         ; same as x1
  y3    = (/1.0-table_length,y1(0)/) ; end at start of y1
  text3 = row_header
  res3               = True
  res3@txFontHeightF = 0.010
  res3@gsFillColor   = "Gray"

; Main table body
  ncr4  = (/nrow,ncol/)           ; nrow rows, ncol columns
  x4    = x2                      ; Start and end x
  y4    = y3                      ; Start and end Y
  text4 = new((/nrow,ncol/),string)

  color_fill4           = new((/nrow,ncol/),string)
  color_fill4           = "white"
  color_fill4(:,ncol-1) = "grey"
  color_fill4(nrow-1,:) = "green"

  res4               = True       ; Set up resource list
; res4@gsnDebug      = True       ; Useful to print NDC row,col values used.
  res4@txFontHeightF = 0.015
  res4@gsFillColor   = color_fill4

  delete (color_fill4)
;-------------------------------------------------------------------
; for table value

  do n = 0,nrow-2
     text4(n,0) = sprintf("%5.2f", lat_ob(n))  
     text4(n,1) = sprintf("%5.2f", lon_ob(n))  
     text4(n,2) = year_ob(n)  
     text4(n,3) = sprintf("%5.2f", M_score(n,0))      ; CO2 Flux
     text4(n,4) = sprintf("%5.2f", M_score(n,1))      ; Net Radiation
     text4(n,5) = sprintf("%5.2f", M_score(n,2))      ; Latent Heat
     text4(n,6) = sprintf("%5.2f", M_score(n,3))      ; Sensible Heat
     text4(n,7) = sprintf("%5.2f", avg(M_score(n,:))) ; avg all fields    
  end do

;    for the last row

     M_co2 = avg(M_score(:,0))
     M_rad = avg(M_score(:,1))
     M_lh  = avg(M_score(:,2))
     M_sh  = avg(M_score(:,3))
     M_all = M_co2+ M_rad +M_lh + M_sh
     
     text4(nrow-1,0) = "-"
     text4(nrow-1,1) = "-"
     text4(nrow-1,2) = "-"
     text4(nrow-1,3) = sprintf("%5.2f", M_co2) ; avg all sites
     text4(nrow-1,4) = sprintf("%5.2f", M_rad) ; avg all sites
     text4(nrow-1,5) = sprintf("%5.2f", M_lh ) ; avg all sites
     text4(nrow-1,6) = sprintf("%5.2f", M_sh ) ; avg all sites
     text4(nrow-1,7) = sprintf("%5.2f", M_all) ; avg all sites

     print (M_co2)
     print (M_rad)
     print (M_lh )
     print (M_sh)
     print (M_all) 
;---------------------------------------------------------------------------
 
  plot_name = "table_site_score"
 
  wks = gsn_open_wks (plot_type,plot_name)
;------------------------------------------
; for table title

  gRes               = True
  gRes@txFontHeightF = 0.02
; gRes@txAngleF      = 90

  title_text = "Model  " + model_name +  "  M_Score"

  gsn_text_ndc(wks,title_text,0.50,0.95,gRes)
;------------------------------------------   

  gsn_table(wks,ncr1,x1,y1,text1,res1)
  gsn_table(wks,ncr2,x2,y2,text2,res2)
  gsn_table(wks,ncr3,x3,y3,text3,res3)
  gsn_table(wks,ncr4,x4,y4,text4,res4) 

  frame(wks)

  system("convert "+plot_name+"."+plot_type+" "+plot_name+"."+plot_type_new)
  system("rm "+plot_name+"."+plot_type)
;-------------------------------------------------------------------
  temp_name = "temp." + model_name
  system("mkdir -p " + temp_name)
  system("mv *.png " + temp_name)
  system("tar cf "+ temp_name +".tar " + temp_name)
;------------------------------------------------------------------- 

end
