#!/bin/csh -f
#-------------------------------------------------------------------
# note: user modifies ONLY the "user modification" section 
#
#       MODEL : model name
#       DIR_M  : directory of model data
#       DIR_O  : directory of observed data
#       DIR_S  : directory of model surface data
#       DIR_SCRIPTS  : directory of run scripts
#       FILE1 : time_mean  climatology from CLM diagnostic package
#       FILE2 : 12-monthly climatology from CLM diagnostic package
#       FILE3 : 12-monthly climatology from ATM diagnostic package
#               leave it blank, if no ATM file:
#               set FILE3 =
#       FILE7 : timeseries file generated from .... 
#       FILE8 : timeseries file generated from .... 
#       GRID  : T31, T42, or 1.9
#       BGC   : cn or casa 
#       ENERGY: new or old (model data fields)
#********************************************************************
# user modification:

# model data (no ATM file)
set MODEL  = CN
set DIR_M  = /fis/cgd/cseg/people/jeff/clamp_data/model/
set FILE1  = i01.10cn_1948-2004_ANN_climo.nc
set FILE2  = i01.10cn_1948-2004_MONS_climo.nc
set FILE3  =
set FILE4  = i01.06cn_1980-2004_ANN_climo.nc
set FILE5  = i01.10cn_1990-2004_ANN_climo.nc
set FILE6  = i01.07cn_1990-2004_ANN_climo.nc
set FILE7  = i01.10cn_Fire_C_1979-2004_monthly.nc
set FILE8  = i01.10cn_ameriflux_1990-2004_monthly.nc
set GRID   = T42
set BGC    = cn
set ENERGY = new

# in the "CLAMP metric processing" section:
#  only 00.initial.ncl and 99.final.ncl are required,
#  user can comment out any one or more of the other ncl scripts,
#  e.g. 
#  #ncl $INPUT_TEXT $DIR_SCRIPTS/10.fire.ncl

# model surface data
set DIR_S  = /fis/cgd/cseg/people/jeff/clamp_data/surface_model/

# observed data
set DIR_O  = /fis/cgd/cseg/people/jeff/clamp_data/observed/

# directory for scripts, templates and ncl files
set DIR_SCRIPTS = /fis/cgd/cseg/people/jeff/clamp/all/

#********************************************************************

# create a directory for the model by copying from a template
if ($FILE3 != "") then
   set TEMPLATE = template_1-model
else
   set TEMPLATE = template_1-model_noCO2
endif
#cp -r $DIR_SCRIPTS/$TEMPLATE $MODEL
rm -rf $MODEL
tar xvpf $DIR_SCRIPTS/$TEMPLATE.tar
mv $TEMPLATE $MODEL

# add quote, to be usesd in INPUT_TEXT
set MODELQ = \"$MODEL\"
set DIRMQ  = \"$DIR_M\"
set F1  = \"$FILE1\"
set F2  = \"$FILE2\"
set F3  = \"$FILE3\"
set F4  = \"$FILE4\"
set F5  = \"$FILE5\"
set F6  = \"$FILE6\"
set F7  = \"$FILE7\"
set F8  = \"$FILE8\"
set GRIDQ   = \"$GRID\"
set BGCQ    = \"$BGC\"
set ENERGYQ = \"$ENERGY\"
set DIRSQ   = \"$DIR_S\"
set DIROQ   = \"$DIR_O\"

set INPUT_TEXT = "model_name=$MODELQ model_grid=$GRIDQ dirm=$DIRMQ film1=$F1 film2=$F2 film3=$F3 film4=$F4 film5=$F5 film6=$F6 film7=$F7 film8=$F8 BGC=$BGCQ ENERGY=$ENERGYQ dirs=$DIRSQ diro=$DIROQ"
 
# CLAMP metric processing
ncl $INPUT_TEXT $DIR_SCRIPTS/00.initial.ncl
ncl $INPUT_TEXT $DIR_SCRIPTS/01.npp.ncl
ncl $INPUT_TEXT $DIR_SCRIPTS/02.lai.ncl

if ($FILE3 != "") then
ncl $INPUT_TEXT $DIR_SCRIPTS/03.co2.ncl
endif

ncl $INPUT_TEXT $DIR_SCRIPTS/04.biomass.ncl
ncl $INPUT_TEXT $DIR_SCRIPTS/06.fluxnet.ncl
ncl $INPUT_TEXT $DIR_SCRIPTS/07.beta.ncl
ncl $INPUT_TEXT $DIR_SCRIPTS/08.turnover.ncl

if ($BGC != "casa") then
ncl $INPUT_TEXT $DIR_SCRIPTS/09.carbon_sink.ncl
else
ncl $INPUT_TEXT $DIR_SCRIPTS/09x.carbon_sink.ncl
endif

if ($BGC != "casa") then
ncl $INPUT_TEXT $DIR_SCRIPTS/10.fire.ncl
endif

ncl $INPUT_TEXT $DIR_SCRIPTS/11.ameriflux.ncl
ncl $INPUT_TEXT $DIR_SCRIPTS/99.final.ncl

# create a tar file from the final output 
tar cf $MODEL.tar $MODEL


