#!/bin/csh -f
#-------------------------------------------------------------------
# note: user modifies ONLY the "user modification" section 
#
#       COMPARE: model1 vs model2
#       MODELn : model name
#       DIR_M  : directory of model data
#       DIR_O  : directory of observed data
#       DIR_S  : directory of model surface data
#       DIR_SCRIPTS  : directory of run scripts
#       FILE1  : time_mean  climatology from CLM diagnostic package
#       FILE2  : 12-monthly climatology from CLM diagnostic package
#       FILE3  : 12-monthly climatology from ATM diagnostic package
#                leave it blank, if no ATM file:
#                set FILE3 =
#       FILE7 : timeseries file generated from .... 
#       FILE8 : timeseries file generated from .... 
#       GRID   : T31, T42, or 1.9
#       BGC    : cn or casa 
#       ENERGY : new or old (fields in model data)
#-------------------------------------------------------------------

#*******************************************************
# user modification-(1)

# directory name of model comparison
#et COMPARE = b30.061n_vs_b30.061m
set COMPARE = i01.36cn_vs_i01.38cn

#*******************************************************
# user modification-(2)

# model1 
set MODEL1 = i01.36cn
set DIR_M  = /lustre/wolf-ddn/scratch/hof/cases1/i01.36cn_out/
set FILE1  = i01.36cn_out_ANN_climo.nc
set FILE2  = i01.36cn_out_MONS_climo.nc
set FILE3  = 
set FILE4  = $FILE1
set FILE5  = $FILE1
set FILE6  = $FILE1
set FILE7  = i01.36cn_Fire_C_2076-2100_monthly.nc
set FILE8  = i01.36cn_ameriflux_2076-2100_monthly.nc
set FILE9  = $FILE1
set FILE10 = $FILE2
set GRID   = 1.9
set BGC    = cn
set ENERGY = old

# in the "CLAMP metric processing" section:
#  only 00.initial.ncl and 99.final.ncl are required,
#  user can comment out any one or more of the other ncl scripts,
#  e.g. 
#  #ncl $INPUT_TEXT $DIR_SCRIPTS/10.fire.ncl

# model surface data
set DIR_S  = /lustre/wolf-ddn/scratch/hof/clamp_data/surface_model/

# observed data
set DIR_O  = /lustre/wolf-ddn/scratch/hof/clamp_data/observed/

# directory for scripts, templates and ncl files
set DIR_SCRIPTS = /lustre/wolf-ddn/scratch/hof/clamp/all/

#********************************************************

# create model1 and model1_vs_model2 directory by copying templates
if ($FILE3 != "") then
   set TEMPLATE1 = template_1-model
   set TEMPLATE2 = template_2-model
else
   set TEMPLATE1 = template_1-model_noCO2
   set TEMPLATE2 = template_2-model_noCO2
endif
#cp -r $DIR_SCRIPTS/$TEMPLATE1 $MODEL1
#cp -r $DIR_SCRIPTS/$TEMPLATE2 $COMPARE
rm -rf $MODEL1
rm -rf $COMPARE
tar xvpf $DIR_SCRIPTS/$TEMPLATE1.tar
mv $TEMPLATE1 $MODEL1
tar xvpf $DIR_SCRIPTS/$TEMPLATE2.tar
mv $TEMPLATE2 $COMPARE

# add quote, to be usesd in INPUT_TEXT
set MODELQ = \"$MODEL1\"
set DIRMQ  = \"$DIR_M\"
set F1  = \"$FILE1\"
set F2  = \"$FILE2\"
set F3  = \"$FILE3\"
set F4  = \"$FILE4\"
set F5  = \"$FILE5\"
set F6  = \"$FILE6\"
set F7  = \"$FILE7\"
set F8  = \"$FILE8\"
set F9  = \"$FILE9\"
set F10 = \"$FILE10\"
set GRIDQ   = \"$GRID\"
set BGCQ    = \"$BGC\"
set ENERGYQ = \"$ENERGY\"
set DIRSQ   = \"$DIR_S\"
set DIROQ   = \"$DIR_O\"
set DIRCQ   = \"$DIR_SCRIPTS\"

set COMPAREQ = \"$COMPARE\"
set MODELN   = \"model1\"

set INPUT_TEXT = "model_name=$MODELQ model_grid=$GRIDQ dirm=$DIRMQ film1=$F1 film2=$F2 film3=$F3 film4=$F4 film5=$F5 film6=$F6 film7=$F7 film8=$F8 film9=$F9 film10=$F10 BGC=$BGCQ ENERGY=$ENERGYQ dirs=$DIRSQ diro=$DIROQ dirscript=$DIRCQ modeln=$MODELN compare=$COMPAREQ"
 
echo "`date` - Running diagnostics for model ${MODELQ}"
# CLAMP metric processing of model1
echo "`date` - Running 00.initial.ncl"
ncl $INPUT_TEXT $DIR_SCRIPTS/00.initial.ncl
echo "`date` - Running 01.npp.ncl"
ncl $INPUT_TEXT $DIR_SCRIPTS/01.npp.ncl
echo "`date` - Running 01.lai.ncl"
ncl $INPUT_TEXT $DIR_SCRIPTS/02.lai.ncl

if ($FILE3 != "") then
echo "`date` - Running 03.co2.ncl"
ncl $INPUT_TEXT $DIR_SCRIPTS/03.co2.ncl
endif

echo "`date` - Running 04.biomass.ncl"
ncl $INPUT_TEXT $DIR_SCRIPTS/04.biomass.ncl
echo "`date` - Running 06.fluxnet.ncl"
ncl $INPUT_TEXT $DIR_SCRIPTS/06.fluxnet.ncl
echo "`date` - Running 07.beta.ncl"
ncl $INPUT_TEXT $DIR_SCRIPTS/07.beta.ncl
echo "`date` - Running 08.turnover.ncl"
ncl $INPUT_TEXT $DIR_SCRIPTS/08.turnover.ncl

if ($BGC != "casa") then
echo "`date` - Running 09.carbon_sink.ncl"
ncl $INPUT_TEXT $DIR_SCRIPTS/09.carbon_sink.ncl
else
echo "`date` - Running 09x.carbon_sink.ncl"
ncl $INPUT_TEXT $DIR_SCRIPTS/09x.carbon_sink.ncl
endif

if ($BGC != "casa") then
echo "`date` - Running 10.fire.ncl"
ncl $INPUT_TEXT $DIR_SCRIPTS/10.fire.ncl
endif

echo "`date` - Running 11.ameriflux.ncl"
ncl $INPUT_TEXT $DIR_SCRIPTS/11.ameriflux.ncl
echo "`date` - Running 99.final.ncl"
ncl $INPUT_TEXT $DIR_SCRIPTS/99.final.ncl

#*******************************************************
# user modification-(3)

# model2
set MODEL2 = i01.38cn
set DIR_M  = /lustre/wolf-ddn/scratch/hof/cases1/i01.38cn_out/
set FILE1  = i01.38cn_out_ANN_climo.nc
set FILE2  = i01.38cn_out_MONS_climo.nc
set FILE3  = 
set FILE4  = $FILE1
set FILE5  = $FILE1
set FILE6  = $FILE1
set FILE7  = i01.38cn_Fire_C_2151-2175_monthly.nc
set FILE8  = i01.38cn_ameriflux_2151-2175_monthly.nc
set FILE9  = $FILE1
set FILE10 = $FILE2
set GRID   = 1.9
set BGC    = cn
set ENERGY = old
#*******************************************************
# create model2 directory by copying templates
if ($FILE3 != "") then
   set TEMPLATE1 = template_1-model
else
   set TEMPLATE1 = template_1-model_noCO2
endif
#cp -r $DIR_SCRIPTS/$TEMPLATE1 $MODEL2
rm -rf $MODEL2
tar xvpf $DIR_SCRIPTS/$TEMPLATE1.tar
mv $TEMPLATE1 $MODEL2

# add quote, to be usesd in INPUT_TEXT
set MODELQ  = \"$MODEL2\"
set DIRMQ   = \"$DIR_M\"
set F1  = \"$FILE1\"
set F2  = \"$FILE2\"
set F3  = \"$FILE3\"
set F4  = \"$FILE4\"
set F5  = \"$FILE5\"
set F6  = \"$FILE6\"
set F7  = \"$FILE7\"
set F8  = \"$FILE8\"
set F9  = \"$FILE9\"
set F10 = \"$FILE10\"
set GRIDQ   = \"$GRID\"
set BGCQ    = \"$BGC\"
set ENERGYQ = \"$ENERGY\"

set COMPAREQ = \"$COMPARE\"
set MODELN   = \"model2\"

set INPUT_TEXT = "model_name=$MODELQ model_grid=$GRIDQ dirm=$DIRMQ film1=$F1 film2=$F2 film3=$F3 film4=$F4 film5=$F5 film6=$F6 film7=$F7 film8=$F8 film9=$F9 film10=$F10 BGC=$BGCQ ENERGY=$ENERGYQ dirs=$DIRSQ diro=$DIROQ dirscript=$DIRCQ modeln=$MODELN compare=$COMPAREQ"
 
echo "`date` - Running diagnostics for model ${MODELQ}"
# CLAMP metric processing of model2
echo "`date` - Running 00.inital.ncl"
ncl $INPUT_TEXT $DIR_SCRIPTS/00.initial.ncl
echo "`date` - Running 01.npp.ncl"
ncl $INPUT_TEXT $DIR_SCRIPTS/01.npp.ncl
echo "`date` - Running 02.lai.ncl"
ncl $INPUT_TEXT $DIR_SCRIPTS/02.lai.ncl

if ($FILE3 != "") then
echo "`date` - Running 03.co2.ncl"
ncl $INPUT_TEXT $DIR_SCRIPTS/03.co2.ncl
endif

echo "`date` - Running 04.biomass.ncl"
ncl $INPUT_TEXT $DIR_SCRIPTS/04.biomass.ncl
echo "`date` - Running 06.fluxnet.ncl"
ncl $INPUT_TEXT $DIR_SCRIPTS/06.fluxnet.ncl
echo "`date` - Running 07.beta.ncl"
ncl $INPUT_TEXT $DIR_SCRIPTS/07.beta.ncl
echo "`date` - Running 08.turnover.ncl"
ncl $INPUT_TEXT $DIR_SCRIPTS/08.turnover.ncl

if ($BGC != "casa") then
echo "`date` - Running 09.carbon_sink.ncl"
ncl $INPUT_TEXT $DIR_SCRIPTS/09.carbon_sink.ncl
else
echo "`date` - Running 09x.carbon_sink.ncl"
ncl $INPUT_TEXT $DIR_SCRIPTS/09x.carbon_sink.ncl
endif

if ($BGC != "casa") then
echo "`date` - Running 10.fire.ncl"
ncl $INPUT_TEXT $DIR_SCRIPTS/10.fire.ncl
endif

echo "`date` - Running 11.ameriflux.ncl"
ncl $INPUT_TEXT $DIR_SCRIPTS/11.ameriflux.ncl
echo "`date` - Running 99.final.ncl"
ncl $INPUT_TEXT $DIR_SCRIPTS/99.final.ncl

# create a tar file from the final output
echo "`date` - tarring up final output into all.tar"
tar cf - $MODEL1 $MODEL2 $COMPARE > all.tar

