; ***********************************************
; zonal average plot
; ***********************************************
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_code.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_csm.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/contributed.ncl"
;************************************************
begin

;************************************************
; read in observed data
;************************************************
 
 a     = addfile ("Npp_T42_mean.nc","r")
 b     = addfile ("i01.03cn_1545-1569_ANN_climo.nc","r")
 c     = addfile ("i01.04casa_1605-1629_ANN_climo.nc","r")

 ta    = a->NPP
 tb    = b->NPP
 tc    = c->NPP
   
 lon   = a->lon 
 lat   = a->lat
 nlon  = dimsizes(lon)
 nlat  = dimsizes(lat)

 s  = new ((/3,nlat/), float)

;************************************************
; set value to 0. at missing point of observed
;************************************************
 delta = 0.00000000001
 x0    = tb(0,:,:)
 ta = where(ismissing(ta).and.(ismissing(x0).or.(x0.lt.delta)),0.,ta)

 s(0,:) = zonalAve(ta(:,:))
 delete (ta)

;************************************************
; for model data
;************************************************
 scale_factor = 86400.*365.

 s(1,:) = zonalAve(tb(0,:,:)) * scale_factor
 delete (tb)     

 s(2,:) = zonalAve(tc(0,:,:)) * scale_factor     
 delete (tc)     

 s@long_name = "NPP (gC/m2/year)"
 
;***************************************************** 
; create plot
;***************************************************** 
  wks = gsn_open_wks("png","xy")              ; create plot
  i   = NhlNewColor(wks,1.0,0.71,0.76)       ; add color to colormap
  j   = NhlNewColor(wks,0.64,0.71,0.8)       ; ditto
  
  res                    = True              ; plot mods desired
  res@gsnDraw            = False             ; don't draw yet
  res@gsnFrame           = False             ; don't advance frame yet

; res@vpHeightF 	 = 0.4               ; change aspect ratio of plot
; res@vpWidthF 	         = 0.7

; res@trXMinF	         = 1890              ; set x-axis minimum

  res@xyMonoLineColor    = "False"           ; want colored lines
  res@xyLineColors       = (/"Red","Blue","Black"/) ; colors chosen
; res@xyLineThicknesses	 = (/3.,3.,4./)      ; line thicknesses
  res@xyLineThicknesses	 = (/2.,2.,2./)      ; line thicknesses
  res@xyDashPatterns	 = (/0.,0.,0./)      ; make all lines solid

  res@tiMainString        = "Zoanl Average"
  res@tiYAxisString	 = "NPP (gC/m2/year)"      ; add a axis title    
  res@txFontHeightF	 = 0.0195            ; change title font heights
  
  plot  = gsn_csm_xy (wks,lat,s,res)       ; create plot

; plot  = fill_xy2(wks,plot(0),time,mnmx(2,:),mnmx(3,:),(/0.64,0.71,0.8/),\
; (/0.64,0.71,0.8/))
; plot  = fill_xy2(wks,plot(0),time,mnmx(0,:),mnmx(1,:),(/1.0,0.71,0.76/),\
; (/1.0,0.71,0.76/))
;*****************************************************   
; Manually create legend
;***************************************************** 
  res_text                    = True                  ; text mods desired
  res_text@txFontHeightF      = 0.015                 ; change text size
  res_text@txJust             = "CenterLeft"          ; text justification

  res_lines                   = True                  ; polyline mods desired
  res_lines@gsLineDashPattern = 0.                    ; solid line
  res_lines@gsLineThicknessF  = 5.                    ; line thicker
  res_lines@gsLineColor       = "red"                 ; line color
  xx = (/-85.,-75./)
  yy = (/1400.,1400./)
  gsn_polyline(wks,plot,xx,yy,res_lines)              ; add polyline
  gsn_text(wks,plot,"Observed",-70.,1400.,res_text); add text
  
  yy = (/1500.,1500./)
  res_lines@gsLineColor       = "blue"                ; change to blue
  gsn_polyline(wks,plot,xx,yy,res_lines)              ; add polyline
  gsn_text(wks,plot,"Model i01.03cn",-70.,1500.,res_text)     ; add text
  
  yy = (/1600.,1600./)
  res_lines@gsLineColor       = "black"               ; change to black
  gsn_polyline(wks,plot,xx,yy,res_lines)              ; add poly line
  gsn_text(wks,plot,"Model i01.04casa",-70.,1600.,res_text) ; add text
;*****************************************************   
; Manually create titles
;*****************************************************   
; res_text@txJust        = "CenterCenter"             ; change justification
; res_text@txFontHeightF = 0.03                       ; change font size
; gsn_text_ndc(wks,"Parallel Climate Model Ensembles",0.55,0.90,res_text)

; res_text@txFontHeightF = 0.02                       ; change font size
; gsn_text_ndc(wks,"Global Temperature Anomalies",0.55,0.86,res_text)

; res_text@txFontHeightF = 0.015                      ; change font size
; gsn_text_ndc(wks,"from 1890-1919 average",0.55,0.83,res_text)
  
  draw(plot)
  frame(wks)                                            ; advance frame
  
end
