; ***********************************************
; xy_4.ncl
; ***********************************************
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_code.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_csm.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/contributed.ncl"
;************************************************
begin
;************************************************
; read in data
;************************************************
 g     = addfile ("data.81.nc","r")
 a     = g->SITE_ID  
 xo    = g->LONG_DD  
 yo    = g->LAT_DD
 c     = g->TNPP_C
;c     = g->ANPP_C
;c     = g->BNPP_C
 cp    = g->PREC_ANN
 do i= 0,dimsizes(cp)-1
 if (ismissing(cp(i))) then
    cp (i) = 100
 end if
 end do  
 d     = int2flt(c)/int2flt(cp)
 print (d)

 nx = dimsizes(xo)
 do i= 0,nx-1
    if (xo(i) .lt. 0.) then
        xo(i) = xo(i)+ 360.
    end if
 end do
;print (xo)
 
 f     = addfile ("i01.03cn_1545-1569_ANN_climo.nc","r")
;f     = addfile ("i01.04casa_1605-1629_ANN_climo.nc","r")
 b     = f->NPP
;b     = f->AGNPP
;b     = f->BGNPP    
 xi    = f->lon     
 yi    = f->lat
 bp    = f->RAIN      

 sec_to_year = 86400.*365.

 bo = linint2_points(xi,yi,b,True,xo,yo,0) * sec_to_year
;print (bo)
 bq = linint2_points(xi,yi,bp,True,xo,yo,0) * sec_to_year 

 bo = bo/bq
 
 ccr = esccr(bo,d,0)
 print (ccr)
 bias = sum(((bo(0,:)-d(:))/d(:))^2)
 print (bias)
 M    = 1. - sqrt(bias/nx)
 print (M)

end
