load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_code.ncl"  
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_csm.ncl"  
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/contributed.ncl"  

begin 
;----------------------------------------------------------
  year_start = 2000
  year_end   = 2005
;----------------------------------------------------------
  diri  = "/fis/cgd/cseg/people/jeff/clamp_data/"
  diro  = "/fis/cgd/cseg/people/jeff/clamp_data/"
  filo1 = "LAI_"+year_start+"-"+year_end+"_ensemble_T42.nc"
  filo2 = "LAI_"+year_start+"-"+year_end+"_mean_T42.nc"
  c = addfile(diro+filo1,"c")
  d = addfile(diro+filo2,"c")

  nyear = year_end - year_start + 1

  do n = year_start,year_end
   
;    fili = "LAI_" + n + "_monthly.nc"
     fili = "LAI_" + n + "_monthly_T42.nc"
     print (fili)
  
     a = addfile(diri+fili,"r")
     x = a->LAI
    
     if (n .eq. year_start) then
        y = x
        printVarSummary (x) 
     else
        y = y + x
     end if

     delete (a)
     delete (x)
     delete (fili)
  end do
      
  y = y/nyear
  printVarSummary (y)
 
  c->LAI  = y

  z = dim_avg_Wrap(y(lat|:,lon|:,time|:))
  printVarSummary (z)
  
  d->LAI  = z     
end

