;************************************************
;    Read ascii, Write nc                         
;************************************************
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_code.ncl"  
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_csm.ncl"  
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/contributed.ncl"   
;************************************************
begin
; final output
  diro  = "/fis/cgd/cseg/people/jeff/clamp_data/co2/"
  filo =  "co2_globalView_.nc"
  c = addfile(diro+filo,"c")
  filedimdef(c,"time",-1,True)

; input ascii files
  diri  = "/fis/cgd/cseg/people/jeff/clamp_data/co2/globalView-C4Mip/seas/"
  b = (/ \
"aia005_02D2_seas.co2", \
"alt_01D0_seas.co2", \
"alt_06C0_seas.co2", \
"alt_06D0_seas.co2", \
"ams_01D0_seas.co2", \
"ams_11C0_seas.co2", \
"asc_01D0_seas.co2", \
"ask_01D0_seas.co2", \
"avi_01D0_seas.co2", \
"azr_01D0_seas.co2", \
"bal_01D1_seas.co2", \
"bgu_11D0_seas.co2", \
"bhd_15C0_seas.co2", \
"bme_01D0_seas.co2", \
"bmw_01D0_seas.co2", \
"brw_01C0_seas.co2", \
"brw_01D0_seas.co2", \
"bsc_01D0_seas.co2", \
"car030_01D2_seas.co2", \
"cba_01D0_seas.co2", \
"cba_04D0_seas.co2", \
"cfa_02D0_seas.co2", \
"cgo_01D0_seas.co2", \
"chr_01D0_seas.co2", \
"cmn_17C0_seas.co2", \
"cmo_01D0_seas.co2", \
"coi_20C0_seas.co2", \
"cpt_36C0_seas.co2", \
"cri_02D0_seas.co2", \
"crz_01D0_seas.co2", \
"csj_06D0_seas.co2", \
"daa_02D0_seas.co2", \
"eic_01D0_seas.co2", \
"esp005_01D2_seas.co2", \
"esp_02D0_seas.co2", \
"frd040_06C3_seas.co2", \
"gmi_01D0_seas.co2", \
"goz_01D0_seas.co2", \
"gsn_24D0_seas.co2", \
"haa005_01D2_seas.co2", \
"hat_20C0_seas.co2", \
"hba_01D0_seas.co2", \
"hfm005_01D2_seas.co2", \
"hun010_35C3_seas.co2", \
"hun_01D0_seas.co2", \
"ice_01D0_seas.co2", \
"itn051_01C3_seas.co2", \
"itn123_01C3_seas.co2", \
"itn496_01C3_seas.co2", \
"itn_01D0_seas.co2", \
"izo_01D0_seas.co2", \
"izo_27C0_seas.co2", \
"jbn_29C0_seas.co2", \
"key_01D0_seas.co2", \
"kum_01D0_seas.co2", \
"kzd_01D0_seas.co2", \
"kzm_01D0_seas.co2", \
"lef011_01C3_seas.co2", \
"lef_01D0_seas.co2", \
"ljo_04D0_seas.co2", \
"lmp_28D0_seas.co2", \
"maa_02D0_seas.co2", \
"mbc_01D0_seas.co2", \
"mhd_01D0_seas.co2", \
"mhdcbc_11C0_seas.co2", \
"mhdrbc_11C0_seas.co2", \
"mid_01D0_seas.co2", \
"mlo_01C0_seas.co2", \
"mlo_01D0_seas.co2", \
"mnm_19C0_seas.co2", \
"mqa_02D0_seas.co2", \
"nwr_01D0_seas.co2", \
"obs023_06C3_seas.co2", \
"opw_01D0_seas.co2", \
"orl005_11D2_seas.co2", \
"palcbc_30C0_seas.co2", \
"palmbc_30C0_seas.co2", \
"pdm_11D0_seas.co2", \
"pfa015_01D2_seas.co2", \
"poc000_01D1_seas.co2", \
"pocn05_01D1_seas.co2", \
"pocs05_01D1_seas.co2", \
"prs_21C0_seas.co2", \
"prs_21D0_seas.co2", \
"psa_01D0_seas.co2", \
"rpb_01D0_seas.co2", \
"rta005_01D2_seas.co2", \
"ryo_19C0_seas.co2", \
"sbl_06C0_seas.co2", \
"sbl_06D0_seas.co2", \
"sch_23C0_seas.co2", \
"scsn03_01D1_seas.co2", \
"sey_01D0_seas.co2", \
"shm_01D0_seas.co2", \
"sis_02D0_seas.co2", \
"smo_01C0_seas.co2", \
"smo_01D0_seas.co2", \
"spo_01C0_seas.co2", \
"spo_01D0_seas.co2", \
"stm_01D0_seas.co2", \
"stmebc_01D0_seas.co2", \
"stp_12D0_seas.co2", \
"sum_01D0_seas.co2", \
"syo_01D0_seas.co2", \
"syo_09C0_seas.co2", \
"tap_01D0_seas.co2", \
"tdf_01D0_seas.co2", \
"trm_11D0_seas.co2", \
"uta_01D0_seas.co2", \
"uum_01D0_seas.co2", \
"wes_23C0_seas.co2", \
"wis_01D0_seas.co2", \
"wkt009_01C3_seas.co2", \
"wlg_01D0_seas.co2", \
"wlg_33C0_seas.co2", \
"wpo000_10D2_seas.co2", \
"wpon05_10D2_seas.co2", \
"wpos05_10D2_seas.co2", \
"yon_19C0_seas.co2", \
"zep_01D0_seas.co2", \
"zep_31C0_seas.co2", \
"zot005_45D2_seas.co2"/)

  ntime = 12
  ncase = dimsizes(b)
  print (ncase)

  mean = new((/ncase,ntime/),float)
  lat  = new((/ncase/),float)
  lon  = new((/ncase/),float)
  elev = new((/ncase/),float) 

  do n = 0,dimsizes(b)-1
     fili = diri + b(n)
     print (fili)
                    
     ncol1 = 4
     data1 = readAsciiTable(fili, ncol1, "float", (/10,17/))

     lat(n)  = data1(0,0)
     lon(n)  = data1(0,1)
     elev(n) = data1(0,2)

     ncol2 = 5
     data2 = readAsciiTable(fili, ncol2, "float", 16)

     mean(n,:) = data2(:,1)
  end do

; mean!0  = "case"
; mean!1  = "time"
; mean&case= ispan(1,ncase,1)
; mean&time= ispan(1,ntime,1)
  mean@units      = "u mol/mol"
  mean@long_name  = "CO2 GlobalView seasonal"

; lat!0     = "case"
; lon!0     = "case"
; elev!0    = "case"
; lat&case  = mean&case
; lon&case  = mean&case
; elev&case = mean&case

  lat@units      = "degrees_north"
  lat@long_name  = "Latitude"
  lon@units      = "degrees_ease"
  lon@long_name  = "Longitude"        
  elev@units      = "m"
  elev@long_name  = "Elevation above sea level"

  print (lat)
  print (mean)
  
  c->LAT       = lat
  c->LON       = lon
  c->ELEV      = elev
  c->CO2_SEAS  = mean  
end
