;*************************************************
; ce_1.ncl
;************************************************
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_code.ncl"  
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_csm.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/contributed.ncl"  
;************************************************
begin

; final output

  diro  = "/fis/cgd/cseg/people/jeff/clamp_data/model/"
  filo =  "class_pft_1.9.nc"
  c = addfile(diro+filo,"c")
 
; read model data

  diri  = "/fis/cgd/cseg/people/jeff/surface_data/"
  fili  = "surfdata_1.9x2.5_cn_070119.nc"
  f     = addfile(diri+fili,"r")

  y     = f->PCT_PFT
; printVarSummary(y)

; read model grid data

  diri  = "/fis/cgd/cseg/people/jeff/surface_data/"
  fili  = "lnd_1.9.nc"   
  g = addfile(diri+fili,"r")

  landmask = g->landmask
  lat      = g->lat
  lon      = g->lon

  nlat = dimsizes(lat)
  nlon = dimsizes(lon)

  x = y(0,:,:)

  x!0   = "lat"
  x&lat = lat            
  x!1   = "lon"
  x&lon = lon
  x@_FillValue = 1.e36
  x@long_name  = "Model PFT Classes"  
  
  do j= 0,nlat-1
  do i= 0,nlon-1
     x(j,i) = maxind(y(:,j,i))      
  end do
  end do 

; print (x)  

  x = where(landmask .lt. 1.,x@_FillValue,x)

  c->CLASS_PFT = x
  c->lat       = lat 
  c->lon       = lon

end