;*************************************************
; ce_1.ncl
;************************************************
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_code.ncl"  
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_csm.ncl"  
;************************************************
begin
;************************************************
; read in observed data
;************************************************
  diri  = "/fis/cgd/cseg/people/jeff/clamp_data/biomass/ob/"
; fili  = "amazon_biomass.nc"
; fili  = "amazon_biomass_T31.nc"
  fili  = "amazon_biomass_T42.nc"
  f     = addfile(diri+fili,"r")

; y     = f->BIOMASS(::50,::50)
  y     = f->BIOMASS
  printVarSummary(y)

  print (min(y)+"/"+max(y))

;************************************************
; create default plot
;************************************************

  wks = gsn_open_wks("ps","xy")         ; open a ps file
  gsn_define_colormap(wks,"gui_default")     ; choose colormap

  res                     = True             ; Use plot options
  res@cnFillOn            = True             ; Turn on color fill
  res@gsnSpreadColors      = True            ; use full colormap
; res@cnFillMode          = "RasterFill"     ; Turn on raster color
; res@lbLabelAutoStride   = True
  res@cnLinesOn           = False            ; Turn off contourn lines
  res@mpFillOn            = False            ; Turn off map fill
  res@gsnAddCyclic        = False
  res@tiMainString        = "LC15_amazon_biomass"

  res@mpMinLatF            = -21.1      ; range to zoom in on
  res@mpMaxLatF            =  13.8
  res@mpMinLonF            =  277.28
  res@mpMaxLonF            =  326.43

  res@gsnSpreadColors     = True             ; use full colormap
  res@cnLevelSelectionMode = "ManualLevels"  ; Manual contour invtervals
; res@cnMinLevelValF       = 1.              ; Min level
; res@cnMaxLevelValF       = 11.             ; Max level
; res@cnLevelSpacingF      = 1.              ; interval
  res@cnMinLevelValF       = 0.              ; Min level
  res@cnMaxLevelValF       = 450.             ; Max level
  res@cnLevelSpacingF      = 50.              ; interval
; pres                            = True     ; panel plot mods desired
; pres@gsnMaximize                = True     ; fill the page

  plot = gsn_csm_contour_map_ce(wks,y,res)   ; for observed
; gsn_panel(wks,plot,(/1,1/),pres)           ; create panel plot
; system("convert xy.ps xy.png")
end