;---------------------------------------------------------------
; convert from 1x1 to T31/T42 
;
; use model T31/T42 lat and lon
; output model area, too.
;
;-------------------------------------------------------------
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_code.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_csm.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/contributed.ncl"
undef("copyatt")
load "/fis/cgd/cseg/people/jeff/ncl/remap_areaave.ncl"
begin
;************************************************
; output data
;************************************************
  diro  = "/fis/cgd/cseg/people/jeff/fire_data/ob/GFEDv2_C/"
  filo  = "Fire_C_1997-2006_monthly_T42.nc"
  c = addfile(diro+filo,"c")
  filedimdef(c,"year",-1,True)

;******************************************************
; input grid: 1deg x 1deg, N->S, 180W-180E
;******************************************************
  diri  = "/fis/cgd/cseg/people/jeff/fire_data/ob/GFEDv2_C/"
  fili  = "Fire_C_1997-2006_monthly_1x1.nc"
  g     = addfile (diri+fili,"r")
  bi    = g->FIRE_C   
  xi    = g->lon 
  yi    = g->lat

  dsizes = dimsizes(bi)
  nyear  = dsizes(0)
  nmonth = dsizes(1)
  nlatx  = dsizes(2)
  nlonx  = dsizes(3) 

;===================================================
; change from 180W-180E, 90N-90S to  0-360E, 90S-90N
;===================================================
 
 yi    = (/ yi(::-1) /)
 bi    = (/ bi(:,:,::-1,:) /)

 b2    = bi
 x2    = xi   
 
 do i= 0,nlonx-1
    if (i .lt. 180) then
       p = i + 180
       xi(p) = x2(i) + 360.      
    else
       p = i - 180
       xi(p) = x2(i)
    end if
    bi(:,:,:,p)= b2(:,:,:,i) 
 end do

 bi&lat =  yi
 bi&lon =  xi

 print (xi)
 print (yi)

;==================================================
; edges 
;==================================================
 
  xi_edge = fspan(0.0, 360.0, nlonx+1)
  xi_edge@units = "degrees_east"
  yi_edge = fspan(-90.0, 90.0, nlatx+1)
  yi_edge@units = "degrees_north"

;==================================================
; area
;==================================================

  deg2rad = 4.0*atan(1.0)/180.0
  earth_rad = 6.37122e6
  dx = earth_rad * deg2rad * (xi_edge(1)-xi_edge(0))
  dsin = sin(deg2rad*yi_edge(1:180)) - sin(deg2rad*yi_edge(0:179))
  area_in = new((/ nlatx, nlonx /), float)
  area_in = conform(area_in, earth_rad*dx*dsin,0)
  area_in@units = "m^2"

;**************************************************************
; output grid: (0-360), (90S-90N)
;**************************************************************
; interpolate into model T31/T42, using model lat and lon

  diri  = "/fis/cgd/cseg/people/jeff/surface_data/"
  fili  = "lnd_T42.nc"   
  b = addfile(diri+fili,"r")
 
  yo   = b->lat
  xo   = b->lon
  nlat = dimsizes(yo)
  nlon = dimsizes(xo)       

  xo_edge = fspan(0.0, 360.0, nlon+1) - 0.5*360.0/nlon
  xo_edge@units = "degrees_east"

  yo_edge = new(nlat+1, float)
  gau_info = gaus(nlat/2)
  yo_edge(0) = -90.0
  yo_edge(1:nlat-1) = doubletofloat(0.5*(gau_info(0:nlat-2,0)+gau_info(1:nlat-1,0)))
  yo_edge(nlat) = 90.0
  yo_edge@units = "degrees_north" 

; yo = 0.5*(yo_edge(0:nlat-1) + yo_edge(1:nlat))
; yo@units = yo_edge@units
; xo = 0.5*(xo_edge(0:nlon-1) + xo_edge(1:nlon))
; xo@units = xo_edge@units
  
;===================================================
; output
;===================================================

  w  = new((/nyear,nmonth,nlat,nlon/),float)

  do m = 0,nyear-1
  do n = 0,nmonth-1
     w(m,n,:,:) = remap_areaave(xi_edge, yi_edge, bi(m,n,:,:), xo_edge, yo_edge)
  end do
  end do

  w!0   = "year"
  w!1   = "month"               
  w!2   = "lat" 
  w&lat = yo            
  w!3   = "lon"
  w&lon = xo  
  w@units      = bi@units
  w@long_name  = bi@long_name
  w@_FillValue = bi@_FillValue   
 
  c->FIRE_C = w
  c->date   = g->date
  c->area   = b->area
 
end
