;*************************************************
; ce_1.ncl
;************************************************
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_code.ncl"  
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_csm.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/contributed.ncl"  
;************************************************
begin
 
;************************************************
; read in model data
;************************************************
  diri  = "/fis/cgd/cseg/people/jeff/clamp/class/"
  fili  = "T42.clamp.surface-data.060412.nc"
  f     = addfile(diri+fili,"r")

  y     = f->PCT_PFT
  printVarSummary(y)

  diri  = "/fis/cgd/cseg/people/jeff/surface_data/"
  fili  = "lnd_T42.nc"   
  g = addfile(diri+fili,"r")

  landmask = g->landmask
  lat      = g->lat
  lon      = g->lon

  nlat = dimsizes(lat)
  nlon = dimsizes(lon)

  x = y(0,:,:)

  x!0   = "lat"
  x&lat = lat            
  x!1   = "lon"
  x&lon = lon
  x@_FillValue = 1.e36
  x@long_name  = "Model PFT Classes"  
  
  do j= 0,nlat-1
  do i= 0,nlon-1
     x(j,i) = maxind(y(:,j,i))      
  end do
  end do 

; print (x)  

  x = where(landmask .lt. 1.,x@_FillValue,x)

;************************************************
; create default plot
;************************************************

  wks = gsn_open_wks("ps","class")              ; open a ps file
  gsn_define_colormap(wks,"gui_default")     ; choose colormap

  res                     = True             ; Use plot options
  res@cnFillOn            = True             ; Turn on color fill
  res@gsnSpreadColors     = True             ; use full colormap
  res@cnLinesOn           = False            ; Turn off contourn lines
  res@mpFillOn            = False            ; Turn off map fill
  res@tiMainString        = "Class"

  res@gsnSpreadColors      = True            ; use full colormap
  res@cnLevelSelectionMode = "ManualLevels"  ; Manual contour invtervals
  res@cnMinLevelValF       = 0.              ; Min level
  res@cnMaxLevelValF       = 16.             ; Max level
  res@cnLevelSpacingF      = 1.              ; interval

  plot = gsn_csm_contour_map_ce(wks,x,res)   

end