;************************************************
;    Read byte, Write nc
; input data is  :   13.8533N -> -21.1277S
;                   -82.7209 -> -33.5739                       
; output data is :  -21.1277S -> 13.8533N
;                    277.2791 -> 326.4261   
;************************************************
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_code.ncl"  
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_csm.ncl"  
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/contributed.ncl"   
;************************************************
begin
; final output
  diro = "/fis/cgd/cseg/people/jeff/clamp_data/biomass/ob/"
  filo =  "amazon_biomass.nc"
  c = addfile(diro+filo,"c")

; input byte file
  diri = "/fis/cgd/cseg/people/jeff/clamp_data/biomass/ob/"
  fili =  "amazon_biomass_byte.nc"
  b = addfile(diri+fili,"r")

  data = byte2flt(b->biomass)

  dsizes_data = dimsizes(data)
  nlat = dsizes_data(0)
  nlon = dsizes_data(1)
; print (nlat)
; print (nlon)
 
  lat  = new((/nlat/),float)
  lon  = new((/nlon/),float)

  latS = -21.1277
  latN =  13.8533
  lonL = -82.7209
  lonR = -33.5739

  dy = abs((latN-latS)/(nlat-1))
  dx = abs((lonR-lonL)/(nlon-1))

  do n = 0,nlat-1
     lat(n) = latS + n*dy
  end do

  do n = 0,nlon-1
     lon(n) = lonL + n*dx + 360.
  end do 
                 
  lat!0  = "lat"
  lon!0  = "lon"
  lat@units      = "degrees_north"
  lat@long_name  = "Latitude"
  lon@units      = "degrees_east"
  lon@long_name  = "Longitude"
  print (lat)
  print (lon)
          
  data!0  = "lat"
  data!1  = "lon"

  data@units      = "Mg C/ha"
  data@long_name  = "Amoazon Biomass"
  data@_FillValue = 1.e+36

; print (data)
  
  c->lat       = lat
  c->lon       = lon
  c->BIOMASS   = data(::-1,:)  
end
