; ****************************************************
; combine  scatter, histogram, global and zonal plots
; *********************************************************

load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_code.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_csm.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/contributed.ncl"
; **********************************************************

; Main code.
begin

;===================================================
; observed station name and location (lat,lon)
;===================================================

 beta_4_ob = 0.60

 station = (/"DukeFACE" \
            ,"AspenFACE" \
            ,"ORNL-FACE" \
            ,"POP-EUROFACE" \
            /)

 lat_ob = (/ 35.58,  45.40,  35.54, 42.22/)
 lon_ob = (/-79.05, -89.37, -84.20, 11.48/)
 lon_ob = where(lon_ob.lt.0.,lon_ob+360.,lon_ob)
;print (lon_ob)

 n_sta  = dimsizes(station)

;====================================================
; model data
;====================================================

 co2_i = 283.1878
 co2_f = 364.1252

;model_name_i = "i01.07cn"
;model_name_f = "i01.10cn"

 model_name_i = "i01.07casa"
 model_name_f = "i01.10casa"

 dirm = "/fis/cgd/cseg/people/jeff/clamp_data/model/"
 film_i = model_name_i + "_1990-2004_ANN_climo.nc"
 film_f = model_name_f + "_1990-2004_ANN_climo.nc"

 fm_i   = addfile (dirm+film_i,"r")
 fm_f   = addfile (dirm+film_f,"r")
  
 npp_i  = fm_i->NPP
 npp_f  = fm_f->NPP
 
 xm       = fm_i->lon  
 ym       = fm_i->lat

 npp_i_4  =linint2_points(xm,ym,npp_i,True,lon_ob,lat_ob,0)

 npp_f_4  =linint2_points(xm,ym,npp_f,True,lon_ob,lat_ob,0)

; Units for these variables are:
; npp_i: g C/m^2/s       

 print (npp_i_4)
 print (npp_f_4)
;============================
;compute beta
;============================

 beta_4 = new((/n_sta/),float)

 beta_4 = ((npp_f_4/npp_i_4) - 1.)/log(co2_f/co2_i)

 beta_4_avg = avg(beta_4)

 print (beta_4)
 print (beta_4_avg)

 M_beta = abs((beta_4_avg/beta_4_ob) - 1.)* 5.
 
 print (M_beta)
end
